-------------------------------------------------------
-- Created by Ben Cope of Imperial College (May 2005)
-- Multiplier for Primary Colour Correction
-------------------------------------------------------

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE IEEE.std_logic_arith.ALL;

LIBRARY UNISIM;
USE UNISIM.VComponents.all;

LIBRARY work;
USE work.Constants.ALL;

ENTITY Multiplier_model IS
 PORT(
  -- Input Signals 
  C : IN STD_LOGIC;
  R : IN STD_LOGIC;
  CE : IN STD_LOGIC;
  A: IN RGB_type;
  B: IN STD_LOGIC_VECTOR(RGB_width DOWNTO 0); 
  
  -- Output Signals
  P: OUT Res_type);
END Multiplier_model;

ARCHITECTURE inside OF Multiplier_model IS
SIGNAL A_ex : STD_LOGIC_VECTOR(RGB_width DOWNTO 0);
SIGNAL result, result_buf : STD_LOGIC_VECTOR(RGB_width*2+1 DOWNTO 0);
SIGNAL OpA, OpB : STD_LOGIC_VECTOR(17 DOWNTO 0);
SIGNAL OpAB : STD_LOGIC_VECTOR(35 DOWNTO 0);

BEGIN


A_ex <= "0" & A;

OpA(17 DOWNTO 17-RGB_width) <= A_ex;
OpA(17-(RGB_width+1) DOWNTO 0) <= (OTHERS => '0');
OpB(17 DOWNTO 17-RGB_width) <= B;
OpB(17-(RGB_width+1) DOWNTO 0) <= (OTHERS => '0');


P1: PROCESS
BEGIN
 WAIT UNTIL Rising_Edge(C);
  IF (CE = '0') THEN
   result <= (OTHERS => '0');
   P <= (OTHERS => '0');
  ELSE
   --result <= signed(A_ex)*signed(B);
	result_buf <= OpAB(35 DOWNTO 35-(2*RGB_width+1));
   P <= result_buf(RGB_width*2 DOWNTO 1);
  END IF;
END PROCESS P1;


MULT18X18S_inst : MULT18X18S
port map (
 P => OpAB,    -- 36-bit multiplier output
 A => OpA,    -- 18-bit multiplier input
 B => OpB,    -- 18-bit multiplier input
 C => C,    -- Clock input
 CE => CE,  -- Clock enable input
 R => R     -- Synchronous reset input
);

END inside;
